
;CodeVisionAVR C Compiler V1.25.8 Professional
;(C) Copyright 1998-2007 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type              : ATmega32
;Program type           : Application
;Clock frequency        : 8.000000 MHz
;Memory model           : Small
;Optimize for           : Size
;(s)printf features     : int, width
;(s)scanf features      : int, width
;External SRAM size     : 0
;Data Stack size        : 512 byte(s)
;Heap size              : 0 byte(s)
;Promote char to int    : Yes
;char is unsigned       : Yes
;8 bit enums            : Yes
;Word align FLASH struct: Yes
;Enhanced core instructions    : On
;Smart register allocation : On
;Automatic register allocation : On

	#pragma AVRPART ADMIN PART_NAME ATmega32
	#pragma AVRPART MEMORY PROG_FLASH 32768
	#pragma AVRPART MEMORY EEPROM 1024
	#pragma AVRPART MEMORY INT_SRAM SIZE 2048
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x60

	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU USR=0xB
	.EQU UDR=0xC
	.EQU SPSR=0xE
	.EQU SPDR=0xF
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E
	.EQU EEARH=0x1F
	.EQU WDTCR=0x21
	.EQU MCUCR=0x35
	.EQU GICR=0x3B
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM
	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM
	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM
	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM
	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM
	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM
	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+@1
	ANDI R30,LOW(@2)
	STS  @0+@1,R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+@1
	ANDI R30,LOW(@2)
	STS  @0+@1,R30
	LDS  R30,@0+@1+1
	ANDI R30,HIGH(@2)
	STS  @0+@1+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+@1
	ORI  R30,LOW(@2)
	STS  @0+@1,R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+@1
	ORI  R30,LOW(@2)
	STS  @0+@1,R30
	LDS  R30,@0+@1+1
	ORI  R30,HIGH(@2)
	STS  @0+@1+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __CLRD1S
	LDI  R30,0
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+@1)
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+@1)
	LDI  R31,HIGH(@0+@1)
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	LDI  R22,BYTE3(2*@0+@1)
	LDI  R23,BYTE4(2*@0+@1)
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+@1)
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+@2)
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+@3)
	LDI  R@1,HIGH(@2+@3)
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+@3)
	LDI  R@1,HIGH(@2*2+@3)
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+@1
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+@1
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	LDS  R22,@0+@1+2
	LDS  R23,@0+@1+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+@2
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+@3
	LDS  R@1,@2+@3+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+@1
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+@1
	LDS  R27,@0+@1+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+@1
	LDS  R27,@0+@1+1
	LDS  R24,@0+@1+2
	LDS  R25,@0+@1+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+@1,R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+@1,R30
	STS  @0+@1+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+@1,R30
	STS  @0+@1+1,R31
	STS  @0+@1+2,R22
	STS  @0+@1+3,R23
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+@1,R0
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+@1,R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+@1,R@2
	STS  @0+@1+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	CALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	CALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	CALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	CLR  R0
	ST   Z+,R0
	ST   Z,R0
	.ENDM

	.MACRO __CLRD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	CLR  R0
	ST   Z+,R0
	ST   Z+,R0
	ST   Z+,R0
	ST   Z,R0
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R@1
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRR0
	MULS R@0,R@1
	.ENDM

	.MACRO __MULBRRU0
	MUL  R@0,R@1
	.ENDM

	.MACRO __MULBNWRU
	LDI  R26,@2
	MUL  R26,R@0
	MOVW R30,R0
	MUL  R26,R@1
	ADD  R31,R0
	.ENDM

	.CSEG
	.ORG 0

	.INCLUDE "gmae.vec"
	.INCLUDE "gmae.inc"

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  GICR,R31
	OUT  GICR,R30
	OUT  MCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,13
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(0x800)
	LDI  R25,HIGH(0x800)
	LDI  R26,0x60
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;STACK POINTER INITIALIZATION
	LDI  R30,LOW(0x85F)
	OUT  SPL,R30
	LDI  R30,HIGH(0x85F)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(0x260)
	LDI  R29,HIGH(0x260)

	JMP  _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x260
;       1 /*****************************************************
;       2 This program was produced by the
;       3 CodeWizardAVR V2.04.4a Advanced
;       4 Automatic Program Generator
;       5  Copyright 1998-2009 Pavel Haiduc, HP InfoTech s.r.l.
;       6 http://www.hpinfotech.com
;       7 
;       8 Project :
;       9 Version :
;      10 Date    : 2010/10/19
;      11 Author  : Mohammad Mazarei
;      12 Company : M2Prog
;      13 Comments:
;      14 
;      15 
;      16 Chip type               : ATmega32
;      17 Program type            : Application
;      18 AVR Core Clock frequency: 8.000000 MHz
;      19 Memory model            : Small
;      20 External RAM size       : 0
;      21 Data Stack size         : 512
;      22 *****************************************************/
;      23 
;      24 #include <mega32.h>
;      25 	#ifndef __SLEEP_DEFINED__
	#ifndef __SLEEP_DEFINED__
;      26 	#define __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
;      27 	.EQU __se_bit=0x80
	.EQU __se_bit=0x80
;      28 	.EQU __sm_mask=0x70
	.EQU __sm_mask=0x70
;      29 	.EQU __sm_powerdown=0x20
	.EQU __sm_powerdown=0x20
;      30 	.EQU __sm_powersave=0x30
	.EQU __sm_powersave=0x30
;      31 	.EQU __sm_standby=0x60
	.EQU __sm_standby=0x60
;      32 	.EQU __sm_ext_standby=0x70
	.EQU __sm_ext_standby=0x70
;      33 	.EQU __sm_adc_noise_red=0x10
	.EQU __sm_adc_noise_red=0x10
;      34 	.SET power_ctrl_reg=mcucr
	.SET power_ctrl_reg=mcucr
;      35 	#endif
	#endif
;      36 #include <delay.h>
;      37 #include <ks0108.h>.
;      38 #include <stdio.h>
;      39 #include "GFX/bitmap.c"
;      40 //
;      41 
;      42 flash char tetris_logo[]=

	.CSEG
;      43 {
;      44 80,7,
;      45 
;      46 0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x81,0x81,0xC1,0x41,0x41,0x41,0x41,0x21,0x21,0x21,0x11,0x11,0x11,0x11,0x31,0x21,0x21,0x21,0x41,0x41,0x41,0x41,0xC1,0x81,0x81,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
;      47 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x40,0x00,0x10,0x00,0x7C,0x7C,0x7E,0x7F,0x78,0xF8,0xF8,0xF8,0xF8,0x00,0x00,0x40,0x40,0xE0,0xD0,0x30,0xF0,0x10,0x30,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x03,0x02,0x06,0x04,0x18,0x30,0x60,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;      48 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x20,0x04,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0F,0x0F,0x0F,0x00,0x3A,0x45,0xAA,0x95,0x55,0x3F,0x01,0x00,0x80,0x41,0x7F,0xC0,0xF0,0xF0,0xF0,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x4F,0x7C,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;      49 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x53,0x3A,0xBC,0x9C,0x5C,0x70,0xC0,0x80,0x00,0x00,0x00,0x00,0x80,0xC0,0x40,0x20,0x10,0x08,0x04,0x02,0x01,0x80,0xC0,0x60,0x18,0x06,0x07,0x1F,0x40,0x80,0x00,0x01,0x07,0x0F,0x3F,0x60,0xC0,0x80,0x00,0x00,0x00,0x80,0xC0,0x70,0x48,0x66,0x65,0xA4,0x44,0x4D,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;      50 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x81,0x00,0x00,0x00,0x00,0x00,0x01,0x19,0x0E,0x06,0x03,0x01,0x00,0x00,0x00,0x00,0xC0,0xE0,0xF8,0xFC,0x03,0xFD,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFF,0x0C,0xF8,0xC0,0x00,0x00,0x06,0x0C,0x03,0x06,0x0E,0x03,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x3B,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;      51 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x08,0x38,0x58,0x98,0x30,0x30,0x30,0x64,0x64,0x64,0x30,0x10,0x0C,0x03,0xFF,0xFF,0xFF,0xFF,0x00,0x7B,0x7B,0x7B,0x7B,0x7B,0xFB,0xFB,0xFB,0x00,0x7F,0x7F,0x7F,0x7C,0x18,0xF8,0xD0,0xC0,0xC0,0x40,0x40,0x20,0xB0,0x50,0x38,0x0C,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;      52 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x04,0x04,0x08,0x10,0x1F,0x3F,0x3F,0x00,0x6F,0x6F,0x6F,0x6F,0xE0,0xFF,0xFF,0xFF,0xFF,0xE0,0xEF,0x6F,0x6F,0x0F,0x6F,0x6F,0x2F,0x2F,0x20,0x0F,0x1F,0x0F,0x0F,0x04,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
;      53 };
;      54 
;      55 flash char agape_logo[]={
;      56 128,8,
;      57 0xFF,0xFF,0xFF,0xFF,0x0F,0x07,0x07,0x07,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x07,0x07,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,
;      58 0xF9,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xF0,0xFE,0x1E,0xE6,0xE6,0xE6,0xC6,0x3E,0xFE,0xF0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xE0,0xF0,0x38,0xDC,0xEC,0xE4,0x76,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x16,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xF0,0xFE,0x1E,0xE6,0xE6,0xE6,0xC6,0x3E,0xFE,0xF0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x06,0x06,0xF6,0xF6,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xF6,0xEE,0xDC,0x3C,0xF8,0xF0,0x00,0xFE,0xFE,0x06,0x06,0xF6,0xF6,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x16,0x0E,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x1F,0x7F,0xFF,0xFF,0xFF,
;      59 0xFF,0xFF,0xFF,0xFF,0xFE,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xFC,0x3F,0xC7,0xF8,0x7F,0x0F,0x01,0x03,0x3F,0xFE,0xF1,0x9F,0xFF,0xFC,0xE0,0x00,0x00,0x00,0x00,0xF8,0xFF,0xFF,0x00,0xFF,0xFF,0x01,0x00,0x00,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x0C,0xFC,0xFC,0x00,0x00,0x00,0x00,0x00,0xE0,0xFC,0x3F,0xC7,0xF8,0x7F,0x0F,0x01,0x03,0x3F,0xFE,0xF1,0x9F,0xFF,0xFC,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3C,0x9F,0xC7,0xF0,0xFF,0x3F,0x00,0xFF,0xFF,0x00,0x00,0xCF,0xCF,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xE0,0xFF,0xFF,0xFF,
;      60 0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0x1C,0x00,0x00,0x00,0xC0,0xF8,0x7F,0xCF,0xF1,0xFE,0x3F,0x63,0x60,0x60,0x60,0x60,0x60,0x61,0x6F,0x7F,0x7C,0x67,0x3F,0xFF,0xF8,0xC0,0x00,0x00,0x0F,0x3F,0xF8,0xE7,0x9F,0xBE,0x70,0x60,0x60,0x60,0x60,0x60,0x60,0x7F,0x7F,0x7F,0x00,0xFF,0xFF,0x00,0x00,0xC0,0xF8,0x7F,0xCF,0xF1,0xFE,0x3F,0x63,0x60,0x60,0x60,0x60,0x60,0x61,0x6F,0x7F,0x7C,0x67,0x3F,0xFF,0xF8,0xC0,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x01,0x01,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x7F,0x7F,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x40,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xFF,0xFF,0xFF,0xFF,0xFF,
;      61 0xFF,0xFF,0xFF,0x03,0x01,0x00,0x00,0x00,0x00,0x02,0x03,0x03,0x02,0x03,0x03,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0xC3,0xC3,0x03,0x03,0x03,0x03,0x03,0x03,0x02,0x00,0x00,0x00,0x00,0x01,0x01,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x02,0x03,0x03,0x02,0x03,0x03,0x00,0x00,0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x02,0x00,0x00,0x03,0x03,0x02,0x02,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x0F,0xFF,0xFF,0xFF,0xFF,
;      62 0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x80,0xC0,0xC0,0x40,0x20,0xA0,0x00,0xFF,0xFF,0x20,0x30,0x60,0x60,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xC0,0xE0,0xF0,0xF0,0xF8,0x78,0x78,0x78,0x38,0x38,0x98,0xE0,0xF0,0xF0,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xF0,0x80,0x00,0x00,0xE0,0xF8,0xF8,0xF8,0xF8,0xF0,0xE0,0xF8,0xF8,0xF8,0x38,0x00,0x00,0xE0,0xF0,0xF8,0xF8,0xF8,0x78,0x78,0x38,0x80,0xE0,0xF0,0xF0,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xF0,0x80,0x00,0x00,0xC0,0xF0,0xF8,0xF8,0xF8,0x38,0x00,0x00,0x00,0x80,0xF0,0xF8,0xF8,0xF8,0xF8,0xF8,0xB8,0xB8,0x38,0x18,0x00,0x00,0xE0,0xFF,0xFF,0xFF,0xFF,
;      63 0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x1F,0x1F,0x7F,0xFF,0xFF,0x71,0x6E,0xFE,0xFF,0xD7,0xD7,0xD7,0xD7,0xF6,0xFF,0xFE,0x6E,0x7F,0x3F,0x3F,0xBE,0x9E,0xD8,0xC0,0x00,0x00,0x00,0x00,0x1F,0x3F,0x7F,0x7F,0x7F,0x79,0x70,0x20,0x00,0x00,0x00,0x0F,0x3F,0x7F,0x7F,0x7F,0x7C,0x7C,0x7F,0x3F,0x3F,0x1F,0x03,0x78,0x7F,0x7F,0x3F,0x0F,0x1F,0x7F,0x7F,0x7F,0x3F,0x1F,0x03,0x70,0x70,0x70,0x7F,0x7F,0x7F,0x7F,0x7F,0x3C,0x00,0x00,0x0F,0x3F,0x7F,0x7F,0x7F,0x7C,0x7C,0x7F,0x3F,0x3F,0x1F,0x03,0x78,0x7F,0x7F,0x7F,0x7F,0x7F,0x78,0x78,0x78,0x00,0x78,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x77,0x77,0x33,0x00,0x00,0x00,0x00,0x0F,0x3F,0xFF,0xFF,0xFF,
;      64 0x7F,0x7F,0xFF,0xFC,0xC0,0xC0,0xC0,0xC0,0xC0,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xFB,0xF2,0xFA,0xFB,0xFB,0xFD,0xFD,0xBD,0xBF,0xBE,0xBE,0x9E,0x9E,0x8F,0x8F,0x87,0x87,0x83,0x81,0x80,0x80,0x80,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xF0,0xF8,0xFF,0xFF
;      65 
;      66 }  ;
;      67 
;      68 
;      69 flash char maze_logo[]=
;      70 {
;      71 80,7,
;      72 0x51,0xA1,0x51,0xA1,0x51,0xA1,0x51,0xA1,0x51,0xE1,0x51,0xB1,0x51,0x01,0x01,0xA1,0x41,0x81,0x41,0x81,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x81,0x41,0xE1,0x51,0xA1,0x01,0x01,0x01,0xB9,0x55,0xF9,0x55,0xB9,0x55,0xA9,0x55,0xB9,0x55,0xA9,0xD5,0xA9,
;      73 0x55,0x0A,0x55,0x22,0x55,0xAA,0x55,0x2B,0x55,0xAF,0x55,0xBB,0x55,0x00,0x00,0xBB,0x55,0xAF,0x55,0xBB,0x55,0xAA,0x54,0x20,0x50,0x00,0x00,0xA0,0x40,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x20,0x54,0x8A,0x55,0x2B,0x55,0xAE,0x55,0xBF,0x00,0x00,0x00,0xBB,0x55,0xAA,0x55,0xAB,0x55,0xAA,0x55,0xAA,0x55,0x8A,0x55,0xAA,
;      74 0x55,0x00,0x55,0x22,0x55,0x88,0x55,0x22,0x55,0xAA,0x55,0xBB,0x01,0x00,0x00,0xBB,0x55,0xAA,0x55,0x22,0x55,0x00,0x55,0x02,0x55,0x00,0x00,0xAA,0x55,0xAA,0x55,0x00,0x00,0xB0,0x50,0x20,0x50,0x80,0x50,0x20,0x50,0xA0,0x50,0x20,0x50,0xA0,0x50,0x00,0x00,0xAA,0x55,0xBB,0x00,0x00,0x55,0x02,0x55,0x00,0x55,0x22,0x55,0xAA,0x55,0xBF,0x00,0x00,0x00,0xBB,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0x00,0x55,0xAA,
;      75 0x55,0x00,0x55,0x22,0x55,0x88,0x55,0x22,0x55,0xAA,0x55,0xBB,0x50,0x00,0x00,0xBB,0x55,0xAA,0x55,0xA2,0x55,0x80,0x55,0x22,0x55,0x00,0x00,0x6A,0x55,0x2A,0x55,0x00,0x00,0x6A,0x55,0x22,0x55,0x20,0x55,0x22,0x55,0x22,0x55,0x22,0x55,0x2A,0x55,0x00,0x00,0x0A,0x15,0x3A,0x00,0x00,0x55,0x00,0x55,0x80,0x55,0x22,0x55,0xAA,0x55,0xFF,0x00,0x00,0x00,0xBB,0x55,0xAA,0x55,0xAA,0x55,0x8A,0x55,0x22,0x55,0x80,0x55,0xAA,
;      76 0x55,0xA8,0x55,0xA2,0x55,0xAA,0x55,0xAA,0x55,0xEA,0x55,0xBB,0x55,0x00,0x00,0x2B,0x55,0xEE,0x55,0x3A,0x55,0x2A,0x15,0x02,0x05,0x02,0x00,0x00,0x00,0x00,0x15,0x2A,0x35,0x0E,0x35,0x22,0x15,0x2A,0x15,0x22,0x15,0x2A,0x15,0x22,0x15,0x2A,0x15,0x2A,0x14,0x28,0x10,0x20,0x00,0x00,0x01,0x02,0x05,0x0A,0x15,0x3A,0x55,0xEA,0x55,0xBB,0x00,0x00,0x00,0xBB,0x55,0xEA,0x55,0xAA,0x55,0xAA,0x55,0xA2,0x55,0xAA,0x55,0xAA,
;      77 0x05,0x02,0x05,0x02,0x05,0x02,0x05,0x03,0x05,0x07,0x05,0x03,0x05,0x00,0x00,0x00,0x01,0x02,0x01,0x00,0x00,0x00,0x50,0x38,0x54,0x6A,0x54,0x7A,0x55,0x6A,0x55,0x2A,0x55,0x68,0x55,0x22,0x55,0x68,0x55,0x22,0x55,0x68,0x55,0x22,0x55,0x68,0x55,0x2A,0x55,0x6A,0x55,0x3A,0x55,0x6A,0x14,0x38,0x10,0x00,0x00,0x00,0x00,0x00,0x01,0x03,0x00,0x00,0x00,0x0B,0x05,0x0F,0x05,0x0B,0x05,0x0E,0x05,0x0A,0x05,0x0A,0x05,0x0A,
;      78 0x54,0xEE,0x54,0xFA,0x54,0xFE,0x14,0x0A,0x00,0x00,0x00,0x80,0x40,0xA0,0x50,0xB8,0x54,0xAC,0x54,0xB8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x50,0xAC,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54,0xB0,0x54,0xA8,0x54,0xB8,0x54,0xA8,0x54,0xB8,0x54,0xF8,0x50,0xA0,0x40,0x80,0x00,0x00,0x50,0xA8,0x70,0xF8,0xD0,0xF8,0x54,0xB8,0x54,0xE8,0x54,0xB8
;      79 
;      80 };
;      81 
;      82 flash char buttom[]={
;      83 
;      84 //next
;      85 0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xFE,0xFE,0xFC,0xF8,0xF0,0xE0,0xC0,0x80,
;      86 0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x7F,0x7F,0x3F,0x1F,0x0F,0x07,0x03,0x01,
;      87 
;      88 0xF0,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x1E,0x02,0x04,0x08,0x10,0x20,0x40,0x80,
;      89 0x0F,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x78,0x40,0x20,0x10,0x08,0x04,0x02,0x01,
;      90 
;      91 //Perv
;      92 0x80,0xC0,0xE0,0xF0,0xF8,0xFC,0xFE,0xFE,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
;      93 0x01,0x03,0x07,0x0F,0x1F,0x3F,0x7F,0x7F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,
;      94 
;      95 0x80,0x40,0x20,0x10,0x08,0x04,0x02,0x1E,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0xF0,
;      96 0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x78,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0F
;      97 
;      98 } ;
;      99 
;     100 #define NEXT    0
;     101 #define NEXT1   1
;     102 #define PERV    2
;     103 #define PERV1   3
;     104 
;     105 
;     106 void show_pic(flash char *pic,char x, char y,char SPEED){
_show_pic:
	PUSH R15
;     107 
;     108 char  i,j,XS,YS;
;     109 
;     110        XS=*pic;
	CALL __SAVELOCR4
;	*pic -> Y+7
;	x -> Y+6
;	y -> Y+5
;	SPEED -> Y+4
;	i -> R17
;	j -> R16
;	XS -> R19
;	YS -> R18
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	LPM  R19,Z
;     111        YS=*(pic+1);
	ADIW R30,1
	LPM  R18,Z
;     112     for(j=0;j<YS;j++){
	LDI  R16,LOW(0)
_0x4:
	CP   R16,R18
	BRLO PC+3
	JMP _0x5
;     113         ks0108_gotoxy(0+x,j+y);;
	LDD  R30,Y+6
	LDI  R31,0
	ADIW R30,0
	ST   -Y,R30
	LDD  R30,Y+6
	LDI  R31,0
	MOV  R26,R16
	LDI  R27,0
	ADD  R30,R26
	ADC  R31,R27
	ST   -Y,R30
	CALL _ks0108_gotoxy
;     114     for(i=0;i<XS;i++)
	LDI  R17,LOW(0)
_0x7:
	CP   R17,R19
	BRLO PC+3
	JMP _0x8
;     115         {
;     116         ks0108_Write(pic[j*XS+i+2]);
	MOV  R30,R19
	LDI  R31,0
	MOV  R26,R16
	LDI  R27,0
	CALL __MULW12
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	ADIW R30,2
	LDD  R26,Y+7
	LDD  R27,Y+7+1
	ADD  R30,R26
	ADC  R31,R27
	LPM  R30,Z
	ST   -Y,R30
	CALL _ks0108_Write
;     117             }
_0x6:
	SUBI R17,-1
	RJMP _0x7
_0x8:
;     118             delay_ms(SPEED);
	LDD  R30,Y+4
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
;     119   }
_0x3:
	SUBI R16,-1
	RJMP _0x4
_0x5:
;     120 
;     121 }
	CALL __LOADLOCR4
	ADIW R28,9
	RET
;     122 
;     123 void echange_right(flash char *pic,flash char *newpic, char x,char y){
_echange_right:
	PUSH R15
;     124 
;     125 char  i,j,XS,YS,c;
;     126 
;     127        XS=*pic;
	CALL __SAVELOCR6
;	*pic -> Y+10
;	*newpic -> Y+8
;	x -> Y+7
;	y -> Y+6
;	i -> R17
;	j -> R16
;	XS -> R19
;	YS -> R18
;	c -> R21
	LDD  R30,Y+10
	LDD  R31,Y+10+1
	LPM  R19,Z
;     128        YS=*(pic+1);
	ADIW R30,1
	LPM  R18,Z
;     129 
;     130     for(c=0;c<XS+1;c+=10){
	LDI  R21,LOW(0)
_0xA:
	MOV  R30,R19
	SUBI R30,-LOW(1)
	CP   R21,R30
	BRLO PC+3
	JMP _0xB
;     131 
;     132         for(i=0;i<XS-c;i++){
	LDI  R17,LOW(0)
_0xD:
	MOV  R30,R21
	LDI  R31,0
	MOV  R26,R19
	LDI  R27,0
	CALL __SWAPW12
	SUB  R30,R26
	SBC  R31,R27
	MOV  R26,R17
	LDI  R27,0
	CP   R26,R30
	CPC  R27,R31
	BRLT PC+3
	JMP _0xE
;     133             for(j=0;j<YS;j++)
	LDI  R16,LOW(0)
_0x10:
	CP   R16,R18
	BRLO PC+3
	JMP _0x11
;     134             {
;     135             ks0108_gotoxy(x+i+c,j+y);
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+7
	LDI  R27,0
	ADD  R26,R30
	ADC  R27,R31
	MOV  R30,R21
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	ST   -Y,R30
	LDD  R30,Y+7
	LDI  R31,0
	MOV  R26,R16
	LDI  R27,0
	ADD  R30,R26
	ADC  R31,R27
	ST   -Y,R30
	CALL _ks0108_gotoxy
;     136             ks0108_Write(pic[j*XS+(i)+2]);
	MOV  R30,R19
	LDI  R31,0
	MOV  R26,R16
	LDI  R27,0
	CALL __MULW12
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	ADIW R30,2
	LDD  R26,Y+10
	LDD  R27,Y+10+1
	ADD  R30,R26
	ADC  R31,R27
	LPM  R30,Z
	ST   -Y,R30
	CALL _ks0108_Write
;     137             }
_0xF:
	SUBI R16,-1
	RJMP _0x10
_0x11:
;     138 
;     139         }
_0xC:
	SUBI R17,-1
	RJMP _0xD
_0xE:
;     140 
;     141         for(i=0;i<c;i++){
	LDI  R17,LOW(0)
_0x13:
	CP   R17,R21
	BRLO PC+3
	JMP _0x14
;     142             for(j=0;j<YS;j++)
	LDI  R16,LOW(0)
_0x16:
	CP   R16,R18
	BRLO PC+3
	JMP _0x17
;     143             {
;     144             ks0108_gotoxy(x+i,j+y);;
	MOV  R30,R17
	LDI  R31,0
	LDD  R26,Y+7
	LDI  R27,0
	ADD  R30,R26
	ADC  R31,R27
	ST   -Y,R30
	LDD  R30,Y+7
	LDI  R31,0
	MOV  R26,R16
	LDI  R27,0
	ADD  R30,R26
	ADC  R31,R27
	ST   -Y,R30
	CALL _ks0108_gotoxy
;     145             ks0108_Write(newpic[j*XS+ (XS-c)+i +2]);
	MOV  R30,R19
	LDI  R31,0
	MOV  R26,R16
	LDI  R27,0
	CALL __MULW12
	MOVW R22,R30
	MOV  R26,R19
	CLR  R27
	MOV  R30,R21
	LDI  R31,0
	CALL __SWAPW12
	SUB  R30,R26
	SBC  R31,R27
	MOVW R26,R22
	ADD  R26,R30
	ADC  R27,R31
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	ADIW R30,2
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	ADD  R30,R26
	ADC  R31,R27
	LPM  R30,Z
	ST   -Y,R30
	CALL _ks0108_Write
;     146            //ks0108_Write(0);
;     147             }
_0x15:
	SUBI R16,-1
	RJMP _0x16
_0x17:
;     148 
;     149         }
_0x12:
	SUBI R17,-1
	RJMP _0x13
_0x14:
;     150 
;     151     }
_0x9:
	SUBI R21,-LOW(10)
	RJMP _0xA
_0xB:
;     152 }
	CALL __LOADLOCR6
	ADIW R28,12
	RET
;     153 
;     154 
;     155 void echange_left(flash char *pic,flash char *newpic, char x,char y){
_echange_left:
	PUSH R15
;     156 
;     157 char  i,j,XS,YS,c;
;     158 
;     159        XS=*pic;
	CALL __SAVELOCR6
;	*pic -> Y+10
;	*newpic -> Y+8
;	x -> Y+7
;	y -> Y+6
;	i -> R17
;	j -> R16
;	XS -> R19
;	YS -> R18
;	c -> R21
	LDD  R30,Y+10
	LDD  R31,Y+10+1
	LPM  R19,Z
;     160        YS=*(pic+1);
	ADIW R30,1
	LPM  R18,Z
;     161 
;     162     for(c=0;c<XS+1;c+=10){
	LDI  R21,LOW(0)
_0x19:
	MOV  R30,R19
	SUBI R30,-LOW(1)
	CP   R21,R30
	BRLO PC+3
	JMP _0x1A
;     163         for(i=c;i<XS;i++){
	MOV  R17,R21
_0x1C:
	CP   R17,R19
	BRLO PC+3
	JMP _0x1D
;     164             for(j=0;j<YS;j++)
	LDI  R16,LOW(0)
_0x1F:
	CP   R16,R18
	BRLO PC+3
	JMP _0x20
;     165             {
;     166             ks0108_gotoxy((i-c)+x,j+y);
	MOV  R30,R21
	LDI  R31,0
	MOV  R26,R17
	LDI  R27,0
	SUB  R26,R30
	SBC  R27,R31
	LDD  R30,Y+7
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	ST   -Y,R30
	LDD  R30,Y+7
	LDI  R31,0
	MOV  R26,R16
	LDI  R27,0
	ADD  R30,R26
	ADC  R31,R27
	ST   -Y,R30
	CALL _ks0108_gotoxy
;     167             ks0108_Write(pic[j*XS+i+2]);
	MOV  R30,R19
	LDI  R31,0
	MOV  R26,R16
	LDI  R27,0
	CALL __MULW12
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	ADIW R30,2
	LDD  R26,Y+10
	LDD  R27,Y+10+1
	ADD  R30,R26
	ADC  R31,R27
	LPM  R30,Z
	ST   -Y,R30
	CALL _ks0108_Write
;     168             }
_0x1E:
	SUBI R16,-1
	RJMP _0x1F
_0x20:
;     169 
;     170         }
_0x1B:
	SUBI R17,-1
	RJMP _0x1C
_0x1D:
;     171 
;     172         for(i=0;i<c;i++){
	LDI  R17,LOW(0)
_0x22:
	CP   R17,R21
	BRLO PC+3
	JMP _0x23
;     173             for(j=0;j<YS;j++)
	LDI  R16,LOW(0)
_0x25:
	CP   R16,R18
	BRLO PC+3
	JMP _0x26
;     174             {
;     175             ks0108_gotoxy(XS-(c-i)+x,j+y);
	MOV  R30,R17
	LDI  R31,0
	MOV  R26,R21
	LDI  R27,0
	CALL __SWAPW12
	SUB  R30,R26
	SBC  R31,R27
	MOV  R26,R19
	LDI  R27,0
	SUB  R26,R30
	SBC  R27,R31
	LDD  R30,Y+7
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	ST   -Y,R30
	LDD  R30,Y+7
	LDI  R31,0
	MOV  R26,R16
	LDI  R27,0
	ADD  R30,R26
	ADC  R31,R27
	ST   -Y,R30
	CALL _ks0108_gotoxy
;     176             ks0108_Write(newpic[j*XS+i+2]);
	MOV  R30,R19
	LDI  R31,0
	MOV  R26,R16
	LDI  R27,0
	CALL __MULW12
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	ADIW R30,2
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	ADD  R30,R26
	ADC  R31,R27
	LPM  R30,Z
	ST   -Y,R30
	CALL _ks0108_Write
;     177             }
_0x24:
	SUBI R16,-1
	RJMP _0x25
_0x26:
;     178 
;     179         }
_0x21:
	SUBI R17,-1
	RJMP _0x22
_0x23:
;     180 
;     181     }
_0x18:
	SUBI R21,-LOW(10)
	RJMP _0x19
_0x1A:
;     182 }
	CALL __LOADLOCR6
	ADIW R28,12
	RET
;     183 
;     184 
;     185 void show_but(char x,char y,char type){
_show_but:
	PUSH R15
;     186 char i;
;     187 
;     188 ks0108_gotoxy(x,y);
	ST   -Y,R17
;	x -> Y+3
;	y -> Y+2
;	type -> Y+1
;	i -> R17
	LDD  R30,Y+3
	ST   -Y,R30
	LDD  R30,Y+3
	ST   -Y,R30
	CALL _ks0108_gotoxy
;     189 for(i=0;i<16;i++)
	LDI  R17,LOW(0)
_0x28:
	CPI  R17,16
	BRLO PC+3
	JMP _0x29
;     190     ks0108_Write(buttom[type*32+i]);
	LDD  R30,Y+1
	LDI  R31,0
	LSL  R30
	ROL  R31
	CALL __LSLW4
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	SUBI R30,LOW(-_buttom*2)
	SBCI R31,HIGH(-_buttom*2)
	LPM  R30,Z
	ST   -Y,R30
	CALL _ks0108_Write
;     191 
;     192 ks0108_gotoxy(x,y+1);
_0x27:
	SUBI R17,-1
	RJMP _0x28
_0x29:
	LDD  R30,Y+3
	ST   -Y,R30
	LDD  R30,Y+3
	SUBI R30,-LOW(1)
	ST   -Y,R30
	CALL _ks0108_gotoxy
;     193 for(i=0;i<16;i++)
	LDI  R17,LOW(0)
_0x2B:
	CPI  R17,16
	BRLO PC+3
	JMP _0x2C
;     194     ks0108_Write(buttom[type*32+16+i]);
	LDD  R30,Y+1
	LDI  R31,0
	LSL  R30
	ROL  R31
	CALL __LSLW4
	ADIW R30,16
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	SUBI R30,LOW(-_buttom*2)
	SBCI R31,HIGH(-_buttom*2)
	LPM  R30,Z
	ST   -Y,R30
	CALL _ks0108_Write
;     195  delay_ms(50);
_0x2A:
	SUBI R17,-1
	RJMP _0x2B
_0x2C:
	LDI  R30,LOW(50)
	LDI  R31,HIGH(50)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
;     196 }
	LDD  R17,Y+0
	ADIW R28,4
	RET
;     197 #include "GFX/sound.h"

	.DSEG
_Tone_G1:
	.BYTE 0x1
_Tempo_G1:
	.BYTE 0x1
_Duration_G1:
	.BYTE 0x1

	.CSEG
_sound_init:
	PUSH R15
	SBI  0x11,7
	SBI  0x12,7
	RET
_play_sound:
	PUSH R15
;	*Sound -> Y+0
	__GETWRS 3,4,0
	LDI  R30,LOW(0)
	OUT  0x22,R30
	LDI  R30,LOW(30)
	OUT  0x25,R30
	LDI  R30,LOW(0)
	OUT  0x24,R30
	OUT  0x23,R30
	LDI  R30,LOW(1)
	MOV  R6,R30
	ADIW R28,2
	RET
_stop_sound:
	PUSH R15
	CLR  R6
	LDI  R30,LOW(0)
	OUT  0x25,R30
	SBI  0x12,7
	RET
_paly_sound_key:
	PUSH R15
	SBIW R28,3
	CALL __SAVELOCR6
;	*song -> Y+9
;	Tone_temp -> R17
;	Tempo_temp -> R16
;	Duration_temp -> R19
;	*pSong_tmep -> R20,R21
;	Do_PLAY_temp -> R18
;	TCCR2_temp -> Y+8
;	TCNT2_tmep -> Y+7
;	OCR2_tmep -> Y+6
	LDS  R17,_Tone_G1
	LDS  R16,_Tempo_G1
	LDS  R19,_Duration_G1
	__MOVEWRR 20,21,3,4
	MOV  R18,R6
	IN   R30,0x25
	STD  Y+8,R30
	IN   R30,0x24
	STD  Y+7,R30
	IN   R30,0x23
	STD  Y+6,R30
	LDI  R30,LOW(1)
	CP   R30,R6
	BREQ PC+3
	JMP _0x33
	CALL __LOADLOCR6
	ADIW R28,11
	RET
_0x33:
	LDI  R30,LOW(0)
	OUT  0x25,R30
	CLR  R6
	__GETWRS 3,4,9
	STS  _Tone_G1,R30
	STS  _Duration_G1,R30
	LDI  R30,LOW(1)
	MOV  R6,R30
	LDI  R30,LOW(30)
	OUT  0x25,R30
_0x34:
	LDI  R30,LOW(1)
	CP   R30,R6
	BREQ PC+3
	JMP _0x36
	RJMP _0x34
_0x36:
	STS  _Tone_G1,R17
	STS  _Tempo_G1,R16
	STS  _Duration_G1,R19
	__MOVEWRR 3,4,20,21
	MOV  R6,R18
	LDD  R30,Y+8
	OUT  0x25,R30
	LDD  R30,Y+7
	OUT  0x24,R30
	LDD  R30,Y+6
	OUT  0x23,R30
	CALL __LOADLOCR6
	ADIW R28,11
	RET
_Play_Tune:
	PUSH R15
	ST   -Y,R17
	ST   -Y,R16
;	temp_tone -> R17
;	loop -> R16
	LDI  R30,LOW(1)
	CP   R30,R6
	BREQ PC+3
	JMP _0x37
	LDS  R30,_Tone_G1
	CPI  R30,0
	BREQ PC+3
	JMP _0x38
	LDI  R30,LOW(0)
	STS  _Duration_G1,R30
	__GETW1R 3,4
	ADIW R30,0
	LPM  R0,Z
	STS  _Tempo_G1,R0
	LDI  R30,LOW(1)
	STS  _Tone_G1,R30
_0x38:
	LDS  R30,_Tempo_G1
	CPI  R30,0
	BREQ PC+3
	JMP _0x39
	LDS  R30,_Duration_G1
	CPI  R30,0
	BRNE PC+3
	JMP _0x3A
	SUBI R30,LOW(1)
	STS  _Duration_G1,R30
	RJMP _0x3B
_0x3A:
	LDS  R30,_Tone_G1
	LDI  R31,0
	ADD  R30,R3
	ADC  R31,R4
	LPM  R30,Z
	CPI  R30,0
	BRNE PC+3
	JMP _0x3C
	LDS  R30,_Tone_G1
	LDI  R31,0
	ADD  R30,R3
	ADC  R31,R4
	LPM  R30,Z
	LDI  R31,0
	LDI  R26,LOW(32)
	LDI  R27,HIGH(32)
	CALL __DIVW21
	STS  _Duration_G1,R30
	LDS  R30,_Tone_G1
	SUBI R30,-LOW(1)
	STS  _Tone_G1,R30
	LDI  R31,0
	ADD  R30,R3
	ADC  R31,R4
	LPM  R17,Z
	MOV  R26,R17
	LDI  R30,LOW(1)
	CALL __EQB12
	MOV  R0,R30
	LDI  R31,0
	OR   R30,R0
	SBIW R30,0
	BRNE PC+3
	JMP _0x3D
	LDI  R30,LOW(0)
	OUT  0x25,R30
	RJMP _0x3E
_0x3D:
	LDI  R30,LOW(30)
	OUT  0x25,R30
_0x3E:
	LDI  R30,LOW(0)
	OUT  0x24,R30
	OUT  0x23,R17
	LDS  R30,_Tone_G1
	SUBI R30,-LOW(1)
	STS  _Tone_G1,R30
	RJMP _0x3F
_0x3C:
	LDS  R30,_Tone_G1
	SUBI R30,-LOW(1)
	STS  _Tone_G1,R30
	LDI  R31,0
	ADD  R30,R3
	ADC  R31,R4
	LPM  R16,Z
	CPI  R16,0
	BRNE PC+3
	JMP _0x40
	LDI  R30,LOW(1)
	STS  _Tone_G1,R30
	RJMP _0x41
_0x40:
	CLR  R6
	LDI  R30,LOW(0)
	OUT  0x25,R30
	SBI  0x12,7
_0x41:
_0x3F:
_0x3B:
	__GETW1R 3,4
	ADIW R30,0
	LPM  R0,Z
	STS  _Tempo_G1,R0
	RJMP _0x44
_0x39:
	LDS  R30,_Tempo_G1
	SUBI R30,LOW(1)
	STS  _Tempo_G1,R30
_0x44:
_0x37:
	LD   R16,Y+
	LD   R17,Y+
	RET
;     198 #include "GFX/wave.h"
;     199 #include "GFX/font.h"
;     200 #include "GFX/GFX.c"
;     201 //
;     202 void put_char(char x,char y,char ch){
_put_char:
	PUSH R15
;     203 char i;
;     204 
;     205 ks0108_gotoxy(x,y);
	ST   -Y,R17
;	x -> Y+3
;	y -> Y+2
;	ch -> Y+1
;	i -> R17
	LDD  R30,Y+3
	ST   -Y,R30
	LDD  R30,Y+3
	ST   -Y,R30
	CALL _ks0108_gotoxy
;     206 for(i=0;i<5;i++)
	LDI  R17,LOW(0)
_0x46:
	CPI  R17,5
	BRLO PC+3
	JMP _0x47
;     207      ks0108_Write(font[(ch-' ')*5+i]);
	LDD  R30,Y+1
	LDI  R31,0
	SBIW R30,32
	LDI  R26,LOW(5)
	LDI  R27,HIGH(5)
	CALL __MULW12
	MOVW R26,R30
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	SUBI R30,LOW(-_font*2)
	SBCI R31,HIGH(-_font*2)
	LPM  R30,Z
	ST   -Y,R30
	CALL _ks0108_Write
;     208 
;     209 }
_0x45:
	SUBI R17,-1
	RJMP _0x46
_0x47:
	LDD  R17,Y+0
	ADIW R28,4
	RET
;     210 
;     211 
;     212 void lputs(char x,char y, char *st){
_lputs:
	PUSH R15
;     213 char i=0;
;     214 
;     215 while(*st!=0){
	ST   -Y,R17
;	x -> Y+4
;	y -> Y+3
;	*st -> Y+1
;	i -> R17
	LDI  R17,0
_0x48:
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	LD   R30,X
	CPI  R30,0
	BRNE PC+3
	JMP _0x4A
;     216     put_char(x+i*6,y,*st);
	MOV  R26,R17
	LDI  R30,LOW(6)
	MUL  R30,R26
	MOVW R30,R0
	LDI  R31,0
	LDD  R26,Y+4
	LDI  R27,0
	ADD  R30,R26
	ADC  R31,R27
	ST   -Y,R30
	LDD  R30,Y+4
	ST   -Y,R30
	LDD  R26,Y+3
	LDD  R27,Y+3+1
	LD   R30,X
	ST   -Y,R30
	CALL _put_char
;     217     i++;
	SUBI R17,-1
;     218     st++;
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ADIW R30,1
	STD  Y+1,R30
	STD  Y+1+1,R31
;     219     }
	RJMP _0x48
_0x4A:
;     220 }
	LDD  R17,Y+0
	ADIW R28,5
	RET
;     221 
;     222 void lputsf(char x,char y,flash char *st){
_lputsf:
	PUSH R15
;     223 
;     224 char i=0;
;     225 
;     226 while(*st!=0){
	ST   -Y,R17
;	x -> Y+4
;	y -> Y+3
;	*st -> Y+1
;	i -> R17
	LDI  R17,0
_0x4B:
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	LPM  R30,Z
	CPI  R30,0
	BRNE PC+3
	JMP _0x4D
;     227     put_char(x+i*6,y,*st);
	MOV  R26,R17
	LDI  R30,LOW(6)
	MUL  R30,R26
	MOVW R30,R0
	LDI  R31,0
	LDD  R26,Y+4
	LDI  R27,0
	ADD  R30,R26
	ADC  R31,R27
	ST   -Y,R30
	LDD  R30,Y+4
	ST   -Y,R30
	LDD  R30,Y+3
	LDD  R31,Y+3+1
	LPM  R30,Z
	ST   -Y,R30
	CALL _put_char
;     228     i++;
	SUBI R17,-1
;     229     st++;
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ADIW R30,1
	STD  Y+1,R30
	STD  Y+1+1,R31
;     230     }
	RJMP _0x4B
_0x4D:
;     231 
;     232 }
	LDD  R17,Y+0
	ADIW R28,5
	RET
;     233 
;     234 
;     235 #include "key.c"
;     236 // KEY
;     237 //Debounce definitions
;     238 #define KEY_DDR     DDRD
;     239 #define KEY_PIN     PIND
;     240 #define KEY_PORT     PORTD
;     241 
;     242 #define BTN_UP      4
;     243 #define BTN_DN      3
;     244 #define BTN_LT      2
;     245 #define BTN_RT      5
;     246 #define BTN_EN      6
;     247 #define BTN_MD      0
;     248 #define BTN_ES      1
;     249 
;     250 #define KEY_MSK     (1<<BTN_UP | 1<<BTN_DN | 1<<BTN_LT | 1<<BTN_RT | 1<<BTN_EN | 1<<BTN_MD | 1<<BTN_ES)
;     251 volatile unsigned char key_press;

	.DSEG
_key_press:
	.BYTE 0x1
;     252 //Debounce
;     253 //unsigned char debounce_cnt = 0;
;     254 unsigned char key_state;
;     255 
;     256 unsigned char get_key_press(unsigned char key_mask)
;     257 {

	.CSEG
_get_key_press:
	PUSH R15
;     258   #asm("cli")
;	key_mask -> Y+0
	cli
;     259   key_mask &= key_press;                        // read key(s)
	LDS  R30,_key_press
	LDI  R31,0
	LD   R26,Y
	AND  R30,R26
	ST   Y,R30
;     260   key_press ^= key_mask;                        // clear key(s)
	LDI  R31,0
	LDS  R26,_key_press
	EOR  R30,R26
	STS  _key_press,R30
;     261   #asm("sei")
	sei
;     262   return key_mask;
	LD   R30,Y
	ADIW R28,1
	RET
;     263 }
;     264 
;     265 void Key_init(void){
_Key_init:
	PUSH R15
;     266 KEY_DDR=~KEY_MSK;
	LDI  R30,LOW(128)
	OUT  0x11,R30
;     267 KEY_PORT=KEY_MSK;
	LDI  R30,LOW(127)
	OUT  0x12,R30
;     268 
;     269 }
	RET
;     270 #include "timer.c"
;     271 
;     272 
;     273 // Timer 0 output compare interrupt service routine
;     274 interrupt [TIM0_COMP] void timer0_comp_isr(void)
;     275 {
_timer0_comp_isr:
;     276       static unsigned char ct0, ct1;

	.DSEG

	.CSEG
;     277   unsigned char i;
;     278   i = key_state ^ ~KEY_PIN;    // key changed ?
	ST   -Y,R17
;	i -> R17
	IN   R30,0x10
	COM  R30
	LDI  R31,0
	EOR  R30,R5
	MOV  R17,R30
;     279   ct0 = ~( ct0 & i );          // reset or count ct0
	MOV  R30,R17
	LDI  R31,0
	MOV  R26,R8
	LDI  R27,0
	AND  R30,R26
	AND  R31,R27
	COM  R30
	COM  R31
	MOV  R8,R30
;     280   ct1 = ct0 ^ (ct1 & i);       // reset or count ct1
	MOV  R30,R17
	LDI  R31,0
	MOV  R26,R7
	LDI  R27,0
	AND  R30,R26
	AND  R31,R27
	EOR  R30,R8
	MOV  R7,R30
;     281   i &= ct0 & ct1;              // count until roll over ?
	MOV  R30,R7
	LDI  R31,0
	MOV  R26,R8
	LDI  R27,0
	AND  R30,R26
	AND  R31,R27
	AND  R17,R30
;     282   key_state ^= i;              // then toggle debounced state
	MOV  R30,R17
	LDI  R31,0
	EOR  R5,R30
;     283   key_press |= key_state & i;  // 0->1: key press detect
	MOV  R30,R17
	LDI  R31,0
	MOV  R26,R5
	LDI  R27,0
	AND  R30,R26
	AND  R31,R27
	LDS  R26,_key_press
	OR   R30,R26
	STS  _key_press,R30
;     284     // Call Evry 10ms in 8MHZ CPU
;     285  Play_Tune();
	CALL _Play_Tune
;     286 }
	LD   R17,Y+
	RETI
;     287 
;     288 
;     289 void init_timer0(){
_init_timer0:
	PUSH R15
;     290 // Timer/Counter 0 initialization
;     291 // Clock source: System Clock
;     292 // Clock value: 7.813 kHz
;     293 // Mode: CTC top=OCR0
;     294 // OC0 output: Disconnected
;     295 TCCR0=0x0D;
	LDI  R30,LOW(13)
	OUT  0x33,R30
;     296 TCNT0=0x00;
	LDI  R30,LOW(0)
	OUT  0x32,R30
;     297 OCR0=0x4E;
	LDI  R30,LOW(78)
	OUT  0x3C,R30
;     298 
;     299 TIMSK=0x02;
	LDI  R30,LOW(2)
	OUT  0x39,R30
;     300 
;     301 
;     302 }
	RET
;     303 #include "game's/maze.c"
;     304 //
;     305 #define xy(x,y)   x+y*16
;     306 #define    UP   1
;     307 #define    DOWN   2
;     308 #define    RIGHT    4
;     309 #define    LEFT    8
;     310 
;     311 struct MAZE_GMAE
;     312 {
;     313 
;     314  char p_x;
;     315  char p_y;
;     316  char s_x;
;     317  char s_y;
;     318  char e_x;
;     319  char e_y;
;     320  int move;
;     321  char level;
;     322  flash char *map;
;     323 }maze;

	.DSEG
_maze:
	.BYTE 0xB
;     324 
;     325 #define level_len   132
;     326 flash char maze_levels[660]={

	.CSEG
;     327 0x02,0x01,
;     328 0x10,0x08,
;     329 0x0D,0x08,0x03,0x03,0x01,0x05,0x09,0x05,0x09,0x03,0x01,0x07,0x0B,0x01,0x03,0x05,
;     330 0x0A,0x04,0x09,0x01,0x02,0x04,0x0C,0x0A,0x04,0x09,0x02,0x03,0x05,0x0A,0x05,0x0C,
;     331 0x0D,0x0C,0x0C,0x0C,0x09,0x06,0x0A,0x05,0x0A,0x06,0x09,0x05,0x0C,0x09,0x06,0x0E,
;     332 0x0C,0x0A,0x02,0x06,0x0A,0x01,0x05,0x0A,0x03,0x05,0x0C,0x0A,0x02,0x06,0x09,0x05,
;     333 0x08,0x07,0x09,0x03,0x01,0x06,0x0A,0x03,0x05,0x0C,0x0C,0x09,0x03,0x05,0x0C,0x0C,
;     334 0x08,0x05,0x0A,0x03,0x02,0x03,0x05,0x09,0x06,0x0C,0x0A,0x02,0x05,0x0C,0x0C,0x0C,
;     335 0x08,0x04,0x09,0x03,0x05,0x09,0x04,0x0A,0x01,0x00,0x07,0x0D,0x0A,0x02,0x06,0x0C,
;     336 0x0E,0x0A,0x02,0x03,0x02,0x06,0x0A,0x07,0x0E,0x0A,0x03,0x06,0x0F,0x0B,0x07,0x0C,
;     337 
;     338 0x08,0x01,
;     339 0x08,0x08,
;     340 0x0D,0x09,0x01,0x03,0x01,0x03,0x05,0x0A,0x03,0x05,0x0D,0x09,0x03,0x03,0x03,0x05,
;     341 0x0C,0x0A,0x02,0x05,0x0A,0x05,0x0A,0x01,0x07,0x0A,0x04,0x0A,0x03,0x05,0x09,0x06,
;     342 0x0C,0x09,0x01,0x00,0x03,0x06,0x09,0x06,0x09,0x03,0x02,0x01,0x03,0x04,0x08,0x07,
;     343 0x0A,0x04,0x0C,0x0A,0x01,0x05,0x08,0x05,0x0A,0x03,0x05,0x08,0x05,0x0C,0x0A,0x05,
;     344 0x09,0x06,0x0A,0x03,0x06,0x0A,0x06,0x08,0x03,0x07,0x0C,0x0E,0x0A,0x04,0x09,0x04,
;     345 0x0C,0x09,0x03,0x01,0x03,0x03,0x05,0x0A,0x05,0x09,0x04,0x09,0x03,0x06,0x0C,0x0C,
;     346 0x08,0x06,0x0D,0x0A,0x03,0x05,0x0A,0x05,0x0A,0x06,0x08,0x02,0x03,0x01,0x06,0x0C,
;     347 0x0E,0x0B,0x06,0x0F,0x0B,0x02,0x07,0x0C,0x0B,0x07,0x0A,0x03,0x03,0x02,0x07,0x0E,
;     348 
;     349 0x01,0x02,
;     350 0x010,0x04,
;     351 0x09,0x05,0x09,0x03,0x01,0x05,0x09,0x05,0x0B,0x05,0x0D,0x09,0x05,0x0D,0x0D,0x0D,
;     352 0x06,0x0A,0x04,0x09,0x02,0x04,0x0C,0x0A,0x01,0x00,0x06,0x0C,0x0C,0x0C,0x0A,0x06,
;     353 0x09,0x05,0x0C,0x0A,0x01,0x06,0x08,0x05,0x0A,0x02,0x05,0x0C,0x0C,0x08,0x03,0x05,
;     354 0x08,0x04,0x0E,0x09,0x00,0x05,0x0C,0x0C,0x09,0x03,0x04,0x0C,0x0E,0x08,0x03,0x02,
;     355 0x0C,0x0C,0x09,0x06,0x0C,0x0A,0x04,0x0C,0x0A,0x05,0x0C,0x0C,0x0B,0x02,0x01,0x07,
;     356 0x08,0x06,0x08,0x07,0x0A,0x03,0x04,0x0C,0x09,0x06,0x0C,0x0C,0x09,0x05,0x08,0x05,
;     357 0x0C,0x09,0x02,0x01,0x05,0x09,0x06,0x0C,0x0C,0x09,0x06,0x0A,0x06,0x0E,0x0A,0x04,
;     358 0x0A,0x06,0x0B,0x06,0x0A,0x02,0x03,0x02,0x06,0x0A,0x03,0x03,0x03,0x03,0x03,0x06,
;     359 
;     360 0x01,0x06,
;     361 0x010,0x04,
;     362 0x0D,0x09,0x07,0x09,0x03,0x03,0x03,0x03,0x03,0x05,0x0B,0x07,0x09,0x03,0x01,0x05,
;     363 0x0C,0x0A,0x05,0x08,0x05,0x09,0x03,0x05,0x09,0x00,0x03,0x07,0x08,0x03,0x06,0x0C,
;     364 0x0C,0x09,0x06,0x0C,0x08,0x06,0x09,0x06,0x08,0x06,0x09,0x01,0x06,0x0B,0x01,0x06,
;     365 0x0C,0x08,0x03,0x04,0x0C,0x0D,0x0A,0x03,0x06,0x09,0x06,0x0C,0x09,0x05,0x0A,0x01,
;     366 0x08,0x02,0x05,0x0A,0x02,0x04,0x09,0x07,0x09,0x02,0x05,0x0C,0x0C,0x0C,0x09,0x06,
;     367 0x06,0x09,0x04,0x09,0x01,0x02,0x06,0x0B,0x06,0x09,0x04,0x0C,0x0C,0x0A,0x02,0x07,
;     368 0x09,0x06,0x0A,0x06,0x0C,0x09,0x03,0x03,0x01,0x02,0x06,0x0A,0x02,0x01,0x03,0x07,
;     369 0x0A,0x03,0x03,0x03,0x02,0x02,0x03,0x07,0x0A,0x03,0x03,0x03,0x07,0x0A,0x03,0x07,
;     370 
;     371 0x01,0x01,
;     372 0x010,0x06,
;     373 0x01,0x03,0x03,0x03,0x05,0x0D,0x09,0x05,0x09,0x05,0x09,0x05,0x09,0x01,0x05,0x0D,
;     374 0x0C,0x09,0x03,0x05,0x0C,0x0C,0x0C,0x0A,0x06,0x0C,0x0C,0x0A,0x04,0x0C,0x08,0x06,
;     375 0x0C,0x0C,0x09,0x06,0x08,0x04,0x0A,0x01,0x05,0x0A,0x06,0x09,0x06,0x0C,0x0E,0x0D,
;     376 0x0A,0x04,0x0A,0x03,0x06,0x08,0x01,0x06,0x0C,0x09,0x03,0x06,0x09,0x02,0x05,0x0C,
;     377 0x0D,0x0A,0x07,0x0B,0x05,0x0C,0x0A,0x05,0x0C,0x0C,0x09,0x03,0x06,0x09,0x02,0x06,
;     378 0x0C,0x09,0x03,0x03,0x02,0x06,0x09,0x04,0x0C,0x0C,0x08,0x05,0x09,0x06,0x09,0x01,
;     379 0x08,0x02,0x05,0x09,0x05,0x09,0x04,0x08,0x06,0x0C,0x0C,0x08,0x02,0x05,0x08,0x06,
;     380 0x0E,0x0F,0x0A,0x06,0x0A,0x06,0x0A,0x02,0x07,0x0A,0x06,0x0A,0x03,0x02,0x06,0x0F
;     381  };
;     382 
;     383 
;     384 flash char sh[]={0x00,0x3C,0x42,0x5A,0x5A,0x42,0x3C,0x00};
;     385 flash char _maze[]=
;     386 {
;     387 0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
;     388 0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
;     389 0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
;     390 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
;     391 0x01,0x01,0x01,0x01,0x01,0x01,0x01,0xFF,
;     392 0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xFF,
;     393 0x81,0x81,0x81,0x81,0x81,0x81,0x81,0xFF,
;     394 0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;     395 0xFF,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
;     396 0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
;     397 0xFF,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
;     398 0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
;     399 0xFF,0x01,0x01,0x01,0x01,0x01,0x01,0xFF,
;     400 0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0xFF,
;     401 0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0xFF
;     402 };
;     403 
;     404 
;     405 
;     406 void Clear_box(char x,char y){
_Clear_box:
	PUSH R15
;     407 
;     408  int i;
;     409  char bg,BGM;
;     410 
;     411  bg=maze.map[xy(x,y)];
	CALL __SAVELOCR4
;	x -> Y+5
;	y -> Y+4
;	i -> R16,R17
;	bg -> R19
;	BGM -> R18
	LDD  R30,Y+4
	SWAP R30
	ANDI R30,0xF0
	LDI  R31,0
	LDD  R26,Y+5
	LDI  R27,0
	ADD  R30,R26
	ADC  R31,R27
	__GETW2MN _maze,9
	ADD  R30,R26
	ADC  R31,R27
	LPM  R19,Z
;     412   ks0108_gotoxy(x*8,y);
	LDD  R30,Y+5
	LSL  R30
	LSL  R30
	LSL  R30
	ST   -Y,R30
	LDD  R30,Y+5
	ST   -Y,R30
	CALL _ks0108_gotoxy
;     413   if (bg==0){
	CPI  R19,0
	BREQ PC+3
	JMP _0x4E
;     414    for(i=0;i<8;i++)
	__GETWRN 16,17,0
_0x50:
	__CPWRN 16,17,8
	BRLT PC+3
	JMP _0x51
;     415     ks0108_Write(0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _ks0108_Write
;     416   return ;
_0x4F:
	__ADDWRN 16,17,1
	RJMP _0x50
_0x51:
	CALL __LOADLOCR4
	ADIW R28,6
	RET
;     417  }
;     418 
;     419  for(i=0;i<8;i++){
_0x4E:
	__GETWRN 16,17,0
_0x53:
	__CPWRN 16,17,8
	BRLT PC+3
	JMP _0x54
;     420     BGM=_maze[(bg-1)*8+i];
	MOV  R26,R19
	LDI  R27,0
	SBIW R26,1
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __MULW12
	ADD  R30,R16
	ADC  R31,R17
	SUBI R30,LOW(-__maze*2)
	SBCI R31,HIGH(-__maze*2)
	LPM  R18,Z
;     421     ks0108_Write(BGM);
	ST   -Y,R18
	CALL _ks0108_Write
;     422     }
_0x52:
	__ADDWRN 16,17,1
	RJMP _0x53
_0x54:
;     423 }
	CALL __LOADLOCR4
	ADIW R28,6
	RET
;     424 
;     425 void Drow_maze_one(char x,char y,char maz){
_Drow_maze_one:
	PUSH R15
;     426 
;     427  int i;
;     428   ks0108_gotoxy(x*8,y);
	ST   -Y,R17
	ST   -Y,R16
;	x -> Y+4
;	y -> Y+3
;	maz -> Y+2
;	i -> R16,R17
	LDD  R30,Y+4
	LSL  R30
	LSL  R30
	LSL  R30
	ST   -Y,R30
	LDD  R30,Y+4
	ST   -Y,R30
	CALL _ks0108_gotoxy
;     429  if (maz==0){
	LDD  R30,Y+2
	CPI  R30,0
	BREQ PC+3
	JMP _0x55
;     430    for(i=0;i<8;i++)
	__GETWRN 16,17,0
_0x57:
	__CPWRN 16,17,8
	BRLT PC+3
	JMP _0x58
;     431     ks0108_Write(0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _ks0108_Write
;     432   return ;
_0x56:
	__ADDWRN 16,17,1
	RJMP _0x57
_0x58:
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,5
	RET
;     433  }
;     434  for(i=0;i<8;i++)
_0x55:
	__GETWRN 16,17,0
_0x5A:
	__CPWRN 16,17,8
	BRLT PC+3
	JMP _0x5B
;     435     ks0108_Write(_maze[(maz-1)*8+i]);
	LDD  R30,Y+2
	LDI  R31,0
	SBIW R30,1
	CALL __LSLW3
	ADD  R30,R16
	ADC  R31,R17
	SUBI R30,LOW(-__maze*2)
	SBCI R31,HIGH(-__maze*2)
	LPM  R30,Z
	ST   -Y,R30
	CALL _ks0108_Write
;     436 
;     437 }
_0x59:
	__ADDWRN 16,17,1
	RJMP _0x5A
_0x5B:
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,5
	RET
;     438 
;     439 void Drow_maze(){
_Drow_maze:
	PUSH R15
;     440  char i,j;
;     441 
;     442   for(j=0;j<8;j++)
	ST   -Y,R17
	ST   -Y,R16
;	i -> R17
;	j -> R16
	LDI  R16,LOW(0)
_0x5D:
	CPI  R16,8
	BRLO PC+3
	JMP _0x5E
;     443     for(i=0;i<16;i++)
	LDI  R17,LOW(0)
_0x60:
	CPI  R17,16
	BRLO PC+3
	JMP _0x61
;     444         Drow_maze_one(i,j,maze.map[xy(i,j)]);
	ST   -Y,R17
	ST   -Y,R16
	MOV  R30,R16
	SWAP R30
	ANDI R30,0xF0
	LDI  R31,0
	MOV  R26,R17
	LDI  R27,0
	ADD  R30,R26
	ADC  R31,R27
	__GETW2MN _maze,9
	ADD  R30,R26
	ADC  R31,R27
	LPM  R30,Z
	ST   -Y,R30
	CALL _Drow_maze_one
;     445 }
_0x5F:
	SUBI R17,-1
	RJMP _0x60
_0x61:
_0x5C:
	SUBI R16,-1
	RJMP _0x5D
_0x5E:
	LD   R16,Y+
	LD   R17,Y+
	RET
;     446 
;     447 
;     448 void Drow_box(char x,char y){
_Drow_box:
	PUSH R15
;     449 
;     450  int i;
;     451  char bg,BGM;
;     452 
;     453  bg=maze.map[xy(x,y)];
	CALL __SAVELOCR4
;	x -> Y+5
;	y -> Y+4
;	i -> R16,R17
;	bg -> R19
;	BGM -> R18
	LDD  R30,Y+4
	SWAP R30
	ANDI R30,0xF0
	LDI  R31,0
	LDD  R26,Y+5
	LDI  R27,0
	ADD  R30,R26
	ADC  R31,R27
	__GETW2MN _maze,9
	ADD  R30,R26
	ADC  R31,R27
	LPM  R19,Z
;     454 
;     455  ks0108_gotoxy(x*8,y);
	LDD  R30,Y+5
	LSL  R30
	LSL  R30
	LSL  R30
	ST   -Y,R30
	LDD  R30,Y+5
	ST   -Y,R30
	CALL _ks0108_gotoxy
;     456  for(i=0;i<8;i++){
	__GETWRN 16,17,0
_0x63:
	__CPWRN 16,17,8
	BRLT PC+3
	JMP _0x64
;     457     BGM=_maze[(bg-1)*8+i];
	MOV  R26,R19
	LDI  R27,0
	SBIW R26,1
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __MULW12
	ADD  R30,R16
	ADC  R31,R17
	SUBI R30,LOW(-__maze*2)
	SBCI R31,HIGH(-__maze*2)
	LPM  R18,Z
;     458     ks0108_Write(sh[i]|BGM);
	MOVW R30,R16
	SUBI R30,LOW(-_sh*2)
	SBCI R31,HIGH(-_sh*2)
	LPM  R30,Z
	MOV  R26,R30
	MOV  R30,R18
	LDI  R31,0
	OR   R30,R26
	ST   -Y,R30
	CALL _ks0108_Write
;     459     }
_0x62:
	__ADDWRN 16,17,1
	RJMP _0x63
_0x64:
;     460 }
	CALL __LOADLOCR4
	ADIW R28,6
	RET
;     461 
;     462 void load_maze(char level){
_load_maze:
	PUSH R15
;     463 
;     464   maze.p_x =maze_levels[level_len*level+0]-1;
;	level -> Y+0
	LD   R30,Y
	LDI  R31,0
	LDI  R26,LOW(132)
	LDI  R27,HIGH(132)
	CALL __MULW12
	__ADDW1FN _maze_levels,0
	LPM  R30,Z
	SUBI R30,LOW(1)
	STS  _maze,R30
;     465   maze.p_y =maze_levels[level_len*level+1]-1;
	LD   R30,Y
	LDI  R31,0
	LDI  R26,LOW(132)
	LDI  R27,HIGH(132)
	CALL __MULW12
	__ADDW1FN _maze_levels,1
	LPM  R30,Z
	SUBI R30,LOW(1)
	__PUTB1MN _maze,1
;     466   maze.s_x =maze_levels[level_len*level+0]-1;
	LD   R30,Y
	LDI  R31,0
	LDI  R26,LOW(132)
	LDI  R27,HIGH(132)
	CALL __MULW12
	__ADDW1FN _maze_levels,0
	LPM  R30,Z
	SUBI R30,LOW(1)
	__PUTB1MN _maze,2
;     467   maze.s_y =maze_levels[level_len*level+1]-1;
	LD   R30,Y
	LDI  R31,0
	LDI  R26,LOW(132)
	LDI  R27,HIGH(132)
	CALL __MULW12
	__ADDW1FN _maze_levels,1
	LPM  R30,Z
	SUBI R30,LOW(1)
	__PUTB1MN _maze,3
;     468   maze.e_x =maze_levels[level_len*level+2]-1;
	LD   R30,Y
	LDI  R31,0
	LDI  R26,LOW(132)
	LDI  R27,HIGH(132)
	CALL __MULW12
	__ADDW1FN _maze_levels,2
	LPM  R30,Z
	SUBI R30,LOW(1)
	__PUTB1MN _maze,4
;     469   maze.e_y =maze_levels[level_len*level+3]-1;
	LD   R30,Y
	LDI  R31,0
	LDI  R26,LOW(132)
	LDI  R27,HIGH(132)
	CALL __MULW12
	__ADDW1FN _maze_levels,3
	LPM  R30,Z
	SUBI R30,LOW(1)
	__PUTB1MN _maze,5
;     470   maze.map = maze_levels+level_len*level+4;
	LD   R30,Y
	LDI  R31,0
	LDI  R26,LOW(132)
	LDI  R27,HIGH(132)
	CALL __MULW12
	SUBI R30,LOW(-_maze_levels*2)
	SBCI R31,HIGH(-_maze_levels*2)
	ADIW R30,4
	__PUTW1MN _maze,9
;     471   maze.move =0;
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	__PUTW1MN _maze,6
;     472 
;     473   Drow_maze();
	CALL _Drow_maze
;     474   Drow_box(maze.p_x ,maze.p_y );
	LDS  R30,_maze
	ST   -Y,R30
	__GETB1MN _maze,1
	ST   -Y,R30
	CALL _Drow_box
;     475 }
	ADIW R28,1
	RET
;     476 
;     477 void maze_init(){
_maze_init:
	PUSH R15
;     478 maze.level=0 ;
	LDI  R30,LOW(0)
	__PUTB1MN _maze,8
;     479 load_maze(maze.level);
	__GETB1MN _maze,8
	ST   -Y,R30
	CALL _load_maze
;     480 
;     481 }
	RET
;     482 
;     483 void move_right(void){
_move_right:
	PUSH R15
;     484    char bg;
;     485         if(maze.p_x == 15 )
	ST   -Y,R17
;	bg -> R17
	LDS  R26,_maze
	CPI  R26,LOW(0xF)
	BREQ PC+3
	JMP _0x65
;     486             return;
	LD   R17,Y+
	RET
;     487         bg=maze.map[xy(maze.p_x ,maze.p_y )];
_0x65:
	__GETB1MN _maze,1
	SWAP R30
	ANDI R30,0xF0
	LDI  R31,0
	LDS  R26,_maze
	LDI  R27,0
	ADD  R30,R26
	ADC  R31,R27
	__GETW2MN _maze,9
	ADD  R30,R26
	ADC  R31,R27
	LPM  R17,Z
;     488         if((bg&RIGHT)==0){
	SBRC R17,2
	RJMP _0x66
;     489         Clear_box(maze.p_x++,maze.p_y );
	LDS  R30,_maze
	SUBI R30,-LOW(1)
	STS  _maze,R30
	SUBI R30,LOW(1)
	ST   -Y,R30
	__GETB1MN _maze,1
	ST   -Y,R30
	CALL _Clear_box
;     490         Drow_box(maze.p_x,maze.p_y);
	LDS  R30,_maze
	ST   -Y,R30
	__GETB1MN _maze,1
	ST   -Y,R30
	CALL _Drow_box
;     491         maze.move++;
	__POINTW2MN _maze,6
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
;     492         }
;     493 
;     494 }
_0x66:
	LD   R17,Y+
	RET
;     495 
;     496 void move_left(void){
_move_left:
	PUSH R15
;     497 
;     498    char bg;
;     499    if(maze.p_x == 0 )
	ST   -Y,R17
;	bg -> R17
	LDS  R30,_maze
	CPI  R30,0
	BREQ PC+3
	JMP _0x67
;     500             return;
	LD   R17,Y+
	RET
;     501         bg=maze.map[xy(maze.p_x,maze.p_y)];
_0x67:
	__GETB1MN _maze,1
	SWAP R30
	ANDI R30,0xF0
	LDI  R31,0
	LDS  R26,_maze
	LDI  R27,0
	ADD  R30,R26
	ADC  R31,R27
	__GETW2MN _maze,9
	ADD  R30,R26
	ADC  R31,R27
	LPM  R17,Z
;     502         if((bg&LEFT)==0){
	SBRC R17,3
	RJMP _0x68
;     503         Clear_box(maze.p_x--,maze.p_y);
	LDS  R30,_maze
	SUBI R30,LOW(1)
	STS  _maze,R30
	SUBI R30,-LOW(1)
	ST   -Y,R30
	__GETB1MN _maze,1
	ST   -Y,R30
	CALL _Clear_box
;     504         Drow_box(maze.p_x,maze.p_y);
	LDS  R30,_maze
	ST   -Y,R30
	__GETB1MN _maze,1
	ST   -Y,R30
	CALL _Drow_box
;     505         maze.move++;
	__POINTW2MN _maze,6
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
;     506         }
;     507 
;     508 }
_0x68:
	LD   R17,Y+
	RET
;     509 
;     510 void move_down(void){
_move_down:
	PUSH R15
;     511     char bg;
;     512             if(maze.p_y == 7 )
	ST   -Y,R17
;	bg -> R17
	__GETB2MN _maze,1
	CPI  R26,LOW(0x7)
	BREQ PC+3
	JMP _0x69
;     513             return;
	LD   R17,Y+
	RET
;     514         bg=maze.map[xy(maze.p_x,maze.p_y)];
_0x69:
	__GETB1MN _maze,1
	SWAP R30
	ANDI R30,0xF0
	LDI  R31,0
	LDS  R26,_maze
	LDI  R27,0
	ADD  R30,R26
	ADC  R31,R27
	__GETW2MN _maze,9
	ADD  R30,R26
	ADC  R31,R27
	LPM  R17,Z
;     515         if((bg&DOWN)==0){
	SBRC R17,1
	RJMP _0x6A
;     516         Clear_box(maze.p_x,maze.p_y++);
	LDS  R30,_maze
	ST   -Y,R30
	__GETB1MN _maze,1
	SUBI R30,-LOW(1)
	__PUTB1MN _maze,1
	SUBI R30,LOW(1)
	ST   -Y,R30
	CALL _Clear_box
;     517         Drow_box(maze.p_x,maze.p_y);
	LDS  R30,_maze
	ST   -Y,R30
	__GETB1MN _maze,1
	ST   -Y,R30
	CALL _Drow_box
;     518         maze.move++;
	__POINTW2MN _maze,6
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
;     519         }
;     520 
;     521 }
_0x6A:
	LD   R17,Y+
	RET
;     522 
;     523 
;     524 void move_up(void){
_move_up:
	PUSH R15
;     525 
;     526    char bg;
;     527         if(maze.p_y ==0 )
	ST   -Y,R17
;	bg -> R17
	__GETB1MN _maze,1
	CPI  R30,0
	BREQ PC+3
	JMP _0x6B
;     528             return;
	LD   R17,Y+
	RET
;     529         bg=maze.map[xy(maze.p_x,maze.p_y)];
_0x6B:
	__GETB1MN _maze,1
	SWAP R30
	ANDI R30,0xF0
	LDI  R31,0
	LDS  R26,_maze
	LDI  R27,0
	ADD  R30,R26
	ADC  R31,R27
	__GETW2MN _maze,9
	ADD  R30,R26
	ADC  R31,R27
	LPM  R17,Z
;     530         if((bg&UP)==0){
	SBRC R17,0
	RJMP _0x6C
;     531         Clear_box(maze.p_x,maze.p_y--);
	LDS  R30,_maze
	ST   -Y,R30
	__GETB1MN _maze,1
	SUBI R30,LOW(1)
	__PUTB1MN _maze,1
	SUBI R30,-LOW(1)
	ST   -Y,R30
	CALL _Clear_box
;     532         Drow_box(maze.p_x,maze.p_y);
	LDS  R30,_maze
	ST   -Y,R30
	__GETB1MN _maze,1
	ST   -Y,R30
	CALL _Drow_box
;     533         maze.move++;
	__POINTW2MN _maze,6
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
;     534         }
;     535 
;     536 }
_0x6C:
	LD   R17,Y+
	RET
;     537 
;     538 char maze_win(){
_maze_win:
	PUSH R15
;     539 
;     540 char temp[5];
;     541 ks0108_ClearScreen();
	SBIW R28,5
;	temp -> Y+0
	CALL _ks0108_ClearScreen
;     542 
;     543 lputsf(20,0,"YOU WIN Level ");
	LDI  R30,LOW(20)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	__POINTW1FN _0,0
	ST   -Y,R31
	ST   -Y,R30
	CALL _lputsf
;     544 put_char(100,0,'0'+maze.level);
	LDI  R30,LOW(100)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	__GETB1MN _maze,8
	LDI  R31,0
	ADIW R30,48
	ST   -Y,R30
	CALL _put_char
;     545 lputsf(7,2,"For New Game Press");
	LDI  R30,LOW(7)
	ST   -Y,R30
	LDI  R30,LOW(2)
	ST   -Y,R30
	__POINTW1FN _0,15
	ST   -Y,R31
	ST   -Y,R30
	CALL _lputsf
;     546 lputsf(40,3,"<-ENTER->");
	LDI  R30,LOW(40)
	ST   -Y,R30
	LDI  R30,LOW(3)
	ST   -Y,R30
	__POINTW1FN _0,34
	ST   -Y,R31
	ST   -Y,R30
	CALL _lputsf
;     547 lputsf(5,4,"Or Esc To Exit Game.");
	LDI  R30,LOW(5)
	ST   -Y,R30
	LDI  R30,LOW(4)
	ST   -Y,R30
	__POINTW1FN _0,44
	ST   -Y,R31
	ST   -Y,R30
	CALL _lputsf
;     548 
;     549 sprintf(temp,"%i",maze.move);
	MOVW R30,R28
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0,65
	ST   -Y,R31
	ST   -Y,R30
	__GETW1MN _maze,6
	CALL __CWD1
	CALL __PUTPARD1
	LDI  R24,4
	CALL _sprintf
	ADIW R28,8
;     550 lputsf(10,6,"Total Movment is ");
	LDI  R30,LOW(10)
	ST   -Y,R30
	LDI  R30,LOW(6)
	ST   -Y,R30
	__POINTW1FN _0,68
	ST   -Y,R31
	ST   -Y,R30
	CALL _lputsf
;     551 lputs(60,7,temp);
	LDI  R30,LOW(60)
	ST   -Y,R30
	LDI  R30,LOW(7)
	ST   -Y,R30
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	CALL _lputs
;     552 maze.level++;
	__GETB1MN _maze,8
	SUBI R30,-LOW(1)
	__PUTB1MN _maze,8
	SUBI R30,LOW(1)
;     553 while(1){
_0x6D:
;     554 
;     555 
;     556        if (get_key_press(1<<BTN_EN)){
	LDI  R30,LOW(64)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BRNE PC+3
	JMP _0x70
;     557        paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;     558        load_maze(maze.level);
	__GETB1MN _maze,8
	ST   -Y,R30
	CALL _load_maze
;     559        return 1;
	LDI  R30,LOW(1)
	ADIW R28,5
	RET
;     560        }
;     561 
;     562         if (get_key_press(1<<BTN_ES)){
_0x70:
	LDI  R30,LOW(2)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BRNE PC+3
	JMP _0x71
;     563        paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;     564        return 0;
	LDI  R30,LOW(0)
	ADIW R28,5
	RET
;     565        }
;     566 }
_0x71:
	RJMP _0x6D
_0x6F:
;     567 }
	ADIW R28,5
	RET
;     568 
;     569 
;     570 void Run_maze(void){
_Run_maze:
	PUSH R15
;     571 
;     572 ks0108_ClearScreen();
	CALL _ks0108_ClearScreen
;     573 maze_init();
	CALL _maze_init
;     574 play_sound(maze_sound);
	LDI  R30,LOW(_maze_sound*2)
	LDI  R31,HIGH(_maze_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _play_sound
;     575 
;     576 while (1)
_0x72:
;     577       {
;     578         if(maze.e_x == maze.p_x  && maze.e_y == maze.p_y){
	__GETB2MN _maze,4
	LDS  R30,_maze
	LDI  R31,0
	LDI  R27,0
	CP   R30,R26
	CPC  R31,R27
	BREQ PC+3
	JMP _0x76
	__GETB2MN _maze,5
	__GETB1MN _maze,1
	LDI  R31,0
	LDI  R27,0
	CP   R30,R26
	CPC  R31,R27
	BREQ PC+3
	JMP _0x76
	RJMP _0x77
_0x76:
	RJMP _0x75
_0x77:
;     579         if(maze_win()==0)
	CALL _maze_win
	CPI  R30,0
	BREQ PC+3
	JMP _0x78
;     580             break;
	RJMP _0x74
;     581         }
_0x78:
;     582 
;     583         if (get_key_press(1<<BTN_MD))
_0x75:
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BRNE PC+3
	JMP _0x79
;     584             if(sound_is_play)
	LDI  R30,LOW(1)
	CP   R30,R6
	BREQ PC+3
	JMP _0x7A
;     585                 stop_sound();
	CALL _stop_sound
;     586             else
	RJMP _0x7B
_0x7A:
;     587                 play_sound(maze_sound);
	LDI  R30,LOW(_maze_sound*2)
	LDI  R31,HIGH(_maze_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _play_sound
;     588 
;     589        if (get_key_press(1<<BTN_RT)){
_0x7B:
_0x79:
	LDI  R30,LOW(32)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BRNE PC+3
	JMP _0x7C
;     590        paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;     591         move_right();
	CALL _move_right
;     592        }
;     593 
;     594        if (get_key_press(1<<BTN_LT)){
_0x7C:
	LDI  R30,LOW(4)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BRNE PC+3
	JMP _0x7D
;     595        paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;     596         move_left();
	CALL _move_left
;     597        }
;     598 
;     599        if (get_key_press(1<<BTN_DN)){
_0x7D:
	LDI  R30,LOW(8)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BRNE PC+3
	JMP _0x7E
;     600         paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;     601         move_down();
	CALL _move_down
;     602         }
;     603 
;     604        if (get_key_press(1<<BTN_UP)){
_0x7E:
	LDI  R30,LOW(16)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BRNE PC+3
	JMP _0x7F
;     605        paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;     606         move_up();
	CALL _move_up
;     607         }
;     608 
;     609        if (get_key_press(1<<BTN_ES)){
_0x7F:
	LDI  R30,LOW(2)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BRNE PC+3
	JMP _0x80
;     610        paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;     611         break;
	RJMP _0x74
;     612         }
;     613       };
_0x80:
	RJMP _0x72
_0x74:
;     614 
;     615 }
	RET
;     616 #include "game's/tetris.c"
;     617 //
;     618 #define BOX_board_bottom 21
;     619 #define BOX_board_right 11
;     620 
;     621 #define array_size (((BOX_board_bottom+8)/8) * (BOX_board_right + 1))
;     622 
;     623 #define default_fg_color 1
;     624 #define default_bg_color 0
;     625 #define GLCD_GoTo(x,y)   ks0108_gotoxy(x,y)
;     626 #define GLCD_WriteData(dat) ks0108_Write(dat)
;     627 
;     628 #define white 0
;     629 
;     630 unsigned char BOX_piece[4];

	.DSEG
_BOX_piece:
	.BYTE 0x4
;     631 
;     632 flash char  BOX_reference[7][4][4] = {

	.CSEG
;     633         //T
;     634         {
;     635                 {
;     636                         0b00000010,
;     637                         0b00000011,
;     638                         0b00000010,
;     639                         0b00000000
;     640                 },
;     641 
;     642                 {
;     643                         0b00000000,
;     644                         0b00000111,
;     645                         0b00000010,
;     646                         0b00000000
;     647                 },
;     648 
;     649                 {
;     650                         0b00000001,
;     651                         0b00000011,
;     652                         0b00000001,
;     653                         0b00000000
;     654                 },
;     655 
;     656                 {
;     657                         0b00000010,
;     658                         0b00000111,
;     659                         0b00000000,
;     660                         0b00000000
;     661                 }
;     662         },
;     663 
;     664         // S
;     665         {
;     666                 {
;     667                         0b00000010,
;     668                         0b00000011,
;     669                         0b00000001,
;     670                         0b00000000
;     671                 },
;     672 
;     673                 {
;     674                         0b00000011,
;     675                         0b00000110,
;     676                         0b00000000,
;     677                         0b00000000
;     678                 },
;     679 
;     680                 {
;     681                         0b00000010,
;     682                         0b00000011,
;     683                         0b00000001,
;     684                         0b00000000
;     685                 },
;     686 
;     687                 {
;     688                         0b00000011,
;     689                         0b00000110,
;     690                         0b00000000,
;     691                         0b00000000
;     692                 }
;     693         },
;     694 
;     695         // Z
;     696         {
;     697                 {
;     698                         0b00000001,
;     699                         0b00000011,
;     700                         0b00000010,
;     701                         0b00000000
;     702                 },
;     703 
;     704                 {
;     705                         0b00000110,
;     706                         0b00000011,
;     707                         0b00000000,
;     708                         0b00000000
;     709                 },
;     710 
;     711                 {
;     712                         0b00000001,
;     713                         0b00000011,
;     714                         0b00000010,
;     715                         0b00000000
;     716                 },
;     717 
;     718                 {
;     719                         0b00000110,
;     720                         0b00000011,
;     721                         0b00000000,
;     722                         0b00000000
;     723                 }
;     724         },
;     725 
;     726         // L
;     727         {
;     728                 {
;     729                         0b00000011,
;     730                         0b00000001,
;     731                         0b00000001,
;     732                         0b00000000
;     733                 },
;     734 
;     735                 {
;     736                         0b00000000,
;     737                         0b00000001,
;     738                         0b00000111,
;     739                         0b00000000
;     740                 },
;     741 
;     742                 {
;     743                         0b00000010,
;     744                         0b00000010,
;     745                         0b00000011,
;     746                         0b00000000
;     747                 },
;     748 
;     749                 {
;     750                         0b00000000,
;     751                         0b00000111,
;     752                         0b00000100,
;     753                         0b00000000
;     754                 }
;     755         },
;     756 
;     757         // J
;     758         {
;     759                 {
;     760                         0b00000001,
;     761                         0b00000001,
;     762                         0b00000011,
;     763                         0b00000000
;     764                 },
;     765 
;     766                 {
;     767                         0b00000000,
;     768                         0b00000100,
;     769                         0b00000111,
;     770                         0b00000000
;     771                 },
;     772 
;     773                 {
;     774                         0b00000011,
;     775                         0b00000010,
;     776                         0b00000010,
;     777                         0b00000000
;     778                 },
;     779 
;     780                 {
;     781                         0b00000000,
;     782                         0b00000111,
;     783                         0b00000001,
;     784                         0b00000000
;     785                 }
;     786         },
;     787 
;     788         // Box
;     789         {
;     790                 {
;     791                         0b00000011,
;     792                         0b00000011,
;     793                         0b00000000,
;     794                         0b00000000
;     795                 },
;     796 
;     797                 {
;     798                         0b00000011,
;     799                         0b00000011,
;     800                         0b00000000,
;     801                         0b00000000
;     802                 },
;     803 
;     804                 {
;     805                         0b00000011,
;     806                         0b00000011,
;     807                         0b00000000,
;     808                         0b00000000
;     809                 },
;     810 
;     811                 {
;     812                         0b00000011,
;     813                         0b00000011,
;     814                         0b00000000,
;     815                         0b00000000
;     816                 }
;     817         },
;     818 
;     819         // Line
;     820         {
;     821                 {
;     822                         0b00000010,
;     823                         0b00000010,
;     824                         0b00000010,
;     825                         0b00000010
;     826                 },
;     827 
;     828                 {
;     829                         0b00000000,
;     830                         0b00001111,
;     831                         0b00000000,
;     832                         0b00000000
;     833                 },
;     834 
;     835                 {
;     836                         0b00000010,
;     837                         0b00000010,
;     838                         0b00000010,
;     839                         0b00000010
;     840                 },
;     841 
;     842                 {
;     843                         0b00000000,
;     844                         0b00001111,
;     845                         0b00000000,
;     846                         0b00000000
;     847                 }
;     848         }
;     849 };
;     850 
;     851 //Variables
;     852 unsigned char BOX_location[array_size];

	.DSEG
_BOX_location:
	.BYTE 0x24
;     853 unsigned char x_loc, y_loc;     //Bottom left index of each piece
;     854 unsigned char cur_piece = 0;	//Index for BOX_reference
;     855 unsigned char rotate = 0;		//Index for piece rotation
;     856 unsigned char score;		//Track the number of rows completed
;     857 
;     858 /**********************************************
;     859  * Functions that handle bits in BOX_location[]
;     860  * BOX_loc_return_bit
;     861  * BOX_loc_set_bit
;     862  * BOX_loc_clear_bit
;     863  ************************************************/
;     864 
;     865 unsigned char BOX_loc_return_bit(unsigned char X, unsigned char Y)
;     866 {

	.CSEG
_BOX_loc_return_bit:
	PUSH R15
;     867   //Calculate array index and shift amount
;     868   unsigned char array_index_offset = ((Y)/8)*(BOX_board_right+1);
;     869   unsigned char shift_index ;		//How much to shift for our bit mask
;     870 
;     871   shift_index = (Y)%8;		//How much to shift for our bit mask
	ST   -Y,R17
	ST   -Y,R16
;	X -> Y+3
;	Y -> Y+2
;	array_index_offset -> R17
;	shift_index -> R16
	LDD  R30,Y+2
	LSR  R30
	LSR  R30
	LSR  R30
	MOV  R26,R30
	LDI  R30,LOW(12)
	MUL  R30,R26
	MOVW R30,R0
	MOV  R17,R30
	LDD  R30,Y+2
	ANDI R30,LOW(0x7)
	MOV  R16,R30
;     872   if (BOX_location[X+array_index_offset] & 1<<shift_index) return 1;
	LDD  R26,Y+3
	CLR  R27
	MOV  R30,R17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	SUBI R30,LOW(-_BOX_location)
	SBCI R31,HIGH(-_BOX_location)
	LD   R1,Z
	MOV  R30,R16
	LDI  R31,0
	LDI  R26,LOW(1)
	LDI  R27,HIGH(1)
	CALL __LSLW12
	MOV  R26,R1
	LDI  R27,0
	AND  R30,R26
	AND  R31,R27
	SBIW R30,0
	BRNE PC+3
	JMP _0x81
	LDI  R30,LOW(1)
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,4
	RET
;     873   else return 0;
_0x81:
	LDI  R30,LOW(0)
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,4
	RET
;     874 }
_0x82:
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,4
	RET
;     875 
;     876 
;     877 void BOX_draw(unsigned char X, unsigned char Y, unsigned char color)
;     878 {
_BOX_draw:
	PUSH R15
;     879       unsigned char temp_data;
;     880       unsigned char i;
;     881 	  if (X%2)
	ST   -Y,R17
	ST   -Y,R16
;	X -> Y+4
;	Y -> Y+3
;	color -> Y+2
;	temp_data -> R17
;	i -> R16
	LDD  R30,Y+4
	ANDI R30,LOW(0x1)
	BRNE PC+3
	JMP _0x83
;     882 	  {
;     883 		  if (BOX_loc_return_bit(X-1,Y))
	LDD  R30,Y+4
	SUBI R30,LOW(1)
	ST   -Y,R30
	LDD  R30,Y+4
	ST   -Y,R30
	CALL _BOX_loc_return_bit
	CPI  R30,0
	BRNE PC+3
	JMP _0x84
;     884 		        temp_data = 0xFF;
	LDI  R17,LOW(255)
;     885 		  else
	RJMP _0x85
_0x84:
;     886 		        temp_data = 0xF0;
	LDI  R17,LOW(0)
_0x85:
	__GETD1N 0x42A8E000
;     887 	  }
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
;     888 	  else
	RJMP _0x86
_0x83:
;     889 	  {
;     890 		  if (BOX_loc_return_bit(X+1,Y)) temp_data = 0xFF;
	LDD  R30,Y+4
	SUBI R30,-LOW(1)
	ST   -Y,R30
	LDD  R30,Y+4
	ST   -Y,R30
	CALL _BOX_loc_return_bit
	CPI  R30,0
	BRNE PC+3
	JMP _0x87
	LDI  R17,LOW(255)
;     891 		  else temp_data = 0x0F;
	RJMP _0x88
_0x87:
	LDI  R17,LOW(15)
;     892 	  }
_0x88:
_0x86:
;     893 }
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,5
	RET
;     894 #include "menu.c"
;     895 //menu
;     896 #define MENU_ITEM   2
;     897 flash char *menu_pic[]={maze_logo,tetris_logo};

	.DSEG
_menu_pic:
	.BYTE 0x4
;     898 char ci=0;
;     899 
;     900 void start_menu(){

	.CSEG
_start_menu:
	PUSH R15
;     901 
;     902 char i;
;     903 flash char *curnet_pic=menu_pic[ci];
;     904 ks0108_ClearScreen();
	CALL __SAVELOCR4
;	i -> R17
;	*curnet_pic -> R18,R19
	MOV  R30,R13
	LDI  R31,0
	LDI  R26,LOW(_menu_pic)
	LDI  R27,HIGH(_menu_pic)
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	MOVW R18,R30
	CALL _ks0108_ClearScreen
;     905 for(i=1;i<8;i++){
	LDI  R17,LOW(1)
_0x8B:
	CPI  R17,8
	BRLO PC+3
	JMP _0x8C
;     906 ks0108_gotoxy(23,i);
	LDI  R30,LOW(23)
	ST   -Y,R30
	ST   -Y,R17
	CALL _ks0108_gotoxy
;     907 ks0108_Write(255);
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _ks0108_Write
;     908 ks0108_gotoxy(104,i);
	LDI  R30,LOW(104)
	ST   -Y,R30
	ST   -Y,R17
	CALL _ks0108_gotoxy
;     909 ks0108_Write(255);
	LDI  R30,LOW(255)
	ST   -Y,R30
	CALL _ks0108_Write
;     910 }
_0x8A:
	SUBI R17,-1
	RJMP _0x8B
_0x8C:
;     911 show_but(2,4,PERV);
	LDI  R30,LOW(2)
	ST   -Y,R30
	LDI  R30,LOW(4)
	ST   -Y,R30
	LDI  R30,LOW(2)
	ST   -Y,R30
	CALL _show_but
;     912 show_but(108,4,NEXT);
	LDI  R30,LOW(108)
	ST   -Y,R30
	LDI  R30,LOW(4)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _show_but
;     913 show_pic(curnet_pic,24,1,0);
	ST   -Y,R19
	ST   -Y,R18
	LDI  R30,LOW(24)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _show_pic
;     914 play_sound(start);
	LDI  R30,LOW(_start*2)
	LDI  R31,HIGH(_start*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _play_sound
;     915 }
	CALL __LOADLOCR4
	ADIW R28,4
	RET
;     916 
;     917 void Show_game_menu(){
_Show_game_menu:
	PUSH R15
;     918 
;     919 
;     920 
;     921 start_menu();
	CALL _start_menu
;     922 
;     923 while(1){
_0x8D:
;     924 
;     925        if (get_key_press(1<<BTN_MD))
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BRNE PC+3
	JMP _0x90
;     926             if(sound_is_play)
	LDI  R30,LOW(1)
	CP   R30,R6
	BREQ PC+3
	JMP _0x91
;     927                 stop_sound();
	CALL _stop_sound
;     928             else
	RJMP _0x92
_0x91:
;     929                 play_sound(start);
	LDI  R30,LOW(_start*2)
	LDI  R31,HIGH(_start*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _play_sound
;     930 
;     931        if (get_key_press(1<<BTN_RT)){  // next Item
_0x92:
_0x90:
	LDI  R30,LOW(32)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BRNE PC+3
	JMP _0x93
;     932             if(ci<MENU_ITEM-1){
	LDI  R30,LOW(1)
	CP   R13,R30
	BRLO PC+3
	JMP _0x94
;     933                 show_but(108,4,NEXT1);
	LDI  R30,LOW(108)
	ST   -Y,R30
	LDI  R30,LOW(4)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _show_but
;     934                 paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;     935                 show_but(108,4,NEXT);
	LDI  R30,LOW(108)
	ST   -Y,R30
	LDI  R30,LOW(4)
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL _show_but
;     936                 echange_left(menu_pic[ci++],menu_pic[ci], 24,1);
	MOV  R30,R13
	INC  R13
	LDI  R26,LOW(_menu_pic)
	LDI  R27,HIGH(_menu_pic)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R13
	LDI  R31,0
	LDI  R26,LOW(_menu_pic)
	LDI  R27,HIGH(_menu_pic)
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(24)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _echange_left
;     937 
;     938                 }
;     939         }
_0x94:
;     940 
;     941        if (get_key_press(1<<BTN_LT)){// Prev item
_0x93:
	LDI  R30,LOW(4)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BRNE PC+3
	JMP _0x95
;     942             if(ci>0){
	LDI  R30,LOW(0)
	CP   R30,R13
	BRLO PC+3
	JMP _0x96
;     943                 show_but(2,4,PERV1);
	LDI  R30,LOW(2)
	ST   -Y,R30
	LDI  R30,LOW(4)
	ST   -Y,R30
	LDI  R30,LOW(3)
	ST   -Y,R30
	CALL _show_but
;     944                 paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;     945                 show_but(2,4,PERV);
	LDI  R30,LOW(2)
	ST   -Y,R30
	LDI  R30,LOW(4)
	ST   -Y,R30
	LDI  R30,LOW(2)
	ST   -Y,R30
	CALL _show_but
;     946                 echange_right(menu_pic[ci--],menu_pic[ci], 24,1);
	MOV  R30,R13
	DEC  R13
	LDI  R26,LOW(_menu_pic)
	LDI  R27,HIGH(_menu_pic)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R13
	LDI  R31,0
	LDI  R26,LOW(_menu_pic)
	LDI  R27,HIGH(_menu_pic)
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(24)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _echange_right
;     947             }
;     948         }
_0x96:
;     949 
;     950         if (get_key_press(1<<BTN_EN)){
_0x95:
	LDI  R30,LOW(64)
	ST   -Y,R30
	CALL _get_key_press
	CPI  R30,0
	BRNE PC+3
	JMP _0x97
;     951            paly_sound_key(key_sound);
	LDI  R30,LOW(_key_sound*2)
	LDI  R31,HIGH(_key_sound*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _paly_sound_key
;     952            switch(ci){
	MOV  R30,R13
	LDI  R31,0
;     953 
;     954            case 0: Run_maze(); break;
	SBIW R30,0
	BREQ PC+3
	JMP _0x9A
	CALL _Run_maze
;     955 
;     956 
;     957            }
_0x9A:
;     958            start_menu();
	CALL _start_menu
;     959         }
;     960 
;     961 }
_0x97:
	RJMP _0x8D
_0x8F:
;     962 
;     963 }
	RET
;     964 
;     965 
;     966 
;     967 
;     968 
;     969 
;     970 
;     971 
;     972 
;     973 void main(void)
;     974 {
_main:
;     975 
;     976 
;     977 ks0108_Init();
	CALL _ks0108_Init
;     978 ks0108_ClearScreen();
	CALL _ks0108_ClearScreen
;     979 sound_init();
	CALL _sound_init
;     980 Key_init();
	CALL _Key_init
;     981 init_timer0();
	CALL _init_timer0
;     982 #asm("sei");
	sei
;     983 play_sound(start);
	LDI  R30,LOW(_start*2)
	LDI  R31,HIGH(_start*2)
	ST   -Y,R31
	ST   -Y,R30
	CALL _play_sound
;     984 show_pic(agape_logo,0,0,50);
	LDI  R30,LOW(_agape_logo*2)
	LDI  R31,HIGH(_agape_logo*2)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R30
	LDI  R30,LOW(50)
	ST   -Y,R30
	CALL _show_pic
;     985 
;     986 // while(1);
;     987 while (1)
_0x9C:
;     988       {
;     989   //     if (get_key_press(1<<BTN_MD))
;     990     //        if(sound_is_play)
;     991       //          stop_sound();
;     992         //    else
;     993           //      play_sound(start);
;     994 
;     995        //if (get_key_press(1<<BTN_EN))
;     996           //  Show_game_menu();
;     997          //
;     998       };
	RJMP _0x9C
_0x9E:
;     999 }
_0x9F:
	RJMP _0x9F
_delay_ms:
	ld   r30,y+
	ld   r31,y+
	adiw r30,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0x7D0
	wdr
	sbiw r30,1
	brne __delay_ms0
__delay_ms1:
	ret

__ANEGW1:
	NEG  R31
	NEG  R30
	SBCI R31,0
	RET

__LSLW12:
	TST  R30
	MOV  R0,R30
	MOVW R30,R26
	BREQ __LSLW12R
__LSLW12L:
	LSL  R30
	ROL  R31
	DEC  R0
	BRNE __LSLW12L
__LSLW12R:
	RET

__LSLW4:
	LSL  R30
	ROL  R31
__LSLW3:
	LSL  R30
	ROL  R31
__LSLW2:
	LSL  R30
	ROL  R31
	LSL  R30
	ROL  R31
	RET

__CWD1:
	MOV  R22,R31
	ADD  R22,R22
	SBC  R22,R22
	MOV  R23,R22
	RET

__EQB12:
	CP   R30,R26
	LDI  R30,1
	BREQ __EQB12T
	CLR  R30
__EQB12T:
	RET

__MULW12U:
	MUL  R31,R26
	MOV  R31,R0
	MUL  R30,R27
	ADD  R31,R0
	MUL  R30,R26
	MOV  R30,R0
	ADD  R31,R1
	RET

__MULW12:
	RCALL __CHKSIGNW
	RCALL __MULW12U
	BRTC __MULW121
	RCALL __ANEGW1
__MULW121:
	RET

__DIVW21U:
	CLR  R0
	CLR  R1
	LDI  R25,16
__DIVW21U1:
	LSL  R26
	ROL  R27
	ROL  R0
	ROL  R1
	SUB  R0,R30
	SBC  R1,R31
	BRCC __DIVW21U2
	ADD  R0,R30
	ADC  R1,R31
	RJMP __DIVW21U3
__DIVW21U2:
	SBR  R26,1
__DIVW21U3:
	DEC  R25
	BRNE __DIVW21U1
	MOVW R30,R26
	MOVW R26,R0
	RET

__DIVW21:
	RCALL __CHKSIGNW
	RCALL __DIVW21U
	BRTC __DIVW211
	RCALL __ANEGW1
__DIVW211:
	RET

__CHKSIGNW:
	CLT
	SBRS R31,7
	RJMP __CHKSW1
	RCALL __ANEGW1
	SET
__CHKSW1:
	SBRS R27,7
	RJMP __CHKSW2
	COM  R26
	COM  R27
	ADIW R26,1
	BLD  R0,0
	INC  R0
	BST  R0,0
__CHKSW2:
	RET

__GETW1P:
	LD   R30,X+
	LD   R31,X
	SBIW R26,1
	RET

__PUTPARD1:
	ST   -Y,R23
	ST   -Y,R22
	ST   -Y,R31
	ST   -Y,R30
	RET

__SWAPW12:
	MOV  R1,R27
	MOV  R27,R31
	MOV  R31,R1

__SWAPB12:
	MOV  R1,R26
	MOV  R26,R30
	MOV  R30,R1
	RET

__SAVELOCR6:
	ST   -Y,R21
__SAVELOCR5:
	ST   -Y,R20
__SAVELOCR4:
	ST   -Y,R19
__SAVELOCR3:
	ST   -Y,R18
__SAVELOCR2:
	ST   -Y,R17
	ST   -Y,R16
	RET

__LOADLOCR6:
	LDD  R21,Y+5
__LOADLOCR5:
	LDD  R20,Y+4
__LOADLOCR4:
	LDD  R19,Y+3
__LOADLOCR3:
	LDD  R18,Y+2
__LOADLOCR2:
	LDD  R17,Y+1
	LD   R16,Y
	RET

;END OF CODE MARKER
__END_OF_CODE:
